% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_markers.R
\name{reduce_markers}
\alias{reduce_markers}
\title{Reduce markers to a subset of more-evenly-spaced ones}
\usage{
reduce_markers(map, min_distance = 1, weights = NULL)
}
\arguments{
\item{map}{A list with each component being a vector with the
marker positions for a chromosome.}

\item{min_distance}{Minimum distance between markers.}

\item{weights}{A (optional) list of weights on the markers; same
size as \code{map}.}
}
\value{
A list like the input \code{map}, but with the selected
subset of markers.
}
\description{
Find the largest subset of markers such that no two adjacent
markers are separated by less than some distance.
}
\details{
Uses a dynamic programming algorithm to find, for each
chromosome, the subset of markers for with max(\code{weights}) is
maximal, subject to the constraint that no two adjacent markers may
be separated by more than \code{min_distance}.
}
\examples{
# read data
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))

# grab genetic map
gmap <- grav2$gmap

# subset to markers that are >= 1 cM apart
gmap_sub <- reduce_markers(gmap, 1)

# drop all of the other markers from the cross
markers2keep <- unlist(lapply(gmap_sub, names))
grav2_sub <- pull_markers(grav2, markers2keep)
}
\references{
Broman KW, Weber JL (1999) Method for constructing
confidently ordered linkage maps. Genet Epidemiol 16:337--343
}
