% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_index_snp.R
\name{find_index_snp}
\alias{find_index_snp}
\title{Find name of indexed snp}
\usage{
find_index_snp(snpinfo, snp)
}
\arguments{
\item{snpinfo}{Data frame with SNP information with the following columns:
\itemize{
\item \code{chr} - Character string or factor with chromosome
\item \code{index} - Numeric index of equivalent, indexed SNP, as produced by \code{\link[=index_snps]{index_snps()}}.
\item \code{snp} - Character string with SNP identifier (if
missing, the rownames are used).
}}

\item{snp}{Name of snp to look for (can be a vector).}
}
\value{
A vector of SNP IDs (the corresponding indexed SNPs), with NA if a SNP is not found.
}
\description{
For a particular SNP, find the name of the corresponding indexed SNP.
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/DO_Recla/recla.zip")
recla <- read_cross2(file)

# founder genotypes for a set of SNPs
snpgeno <- rbind(m1=c(3,1,1,3,1,1,1,1),
                 m2=c(3,1,1,3,1,1,1,1),
                 m3=c(1,1,1,1,3,3,3,3),
                 m4=c(1,3,1,3,1,3,1,3))
sdp <- calc_sdp(snpgeno)
snpinfo <- data.frame(chr=c("19", "19", "X", "X"),
                      pos=c(40.36, 40.53, 110.91, 111.21),
                      sdp=sdp,
                      snp=c("m1", "m2", "m3", "m4"), stringsAsFactors=FALSE)

# update snp info by adding the SNP index column
snpinfo <- index_snps(recla$pmap, snpinfo)

# find indexed snp for a particular snp
find_index_snp(snpinfo, "m3")
}

}
\seealso{
\code{\link[=find_marker]{find_marker()}}
}
