% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_threshold.R
\name{add_threshold}
\alias{add_threshold}
\title{Add thresholds to genome scan plot}
\usage{
add_threshold(map, thresholdA, thresholdX = NULL, chr = NULL, gap = NULL, ...)
}
\arguments{
\item{map}{Marker map used in the genome scan plot}

\item{thresholdA}{Autosomal threshold. Numeric or a list. (If a
list, the \code{"A"} component is taken to be \code{thresholdA} and the
\code{"X"} component is taken to be \code{thresholdX}.)}

\item{thresholdX}{X chromosome threshold (if missing, assumed to be the same as \code{thresholdA})}

\item{chr}{Chromosomes that were included in the plot}

\item{gap}{Gap between chromosomes in the plot. Default is 1\% of the total genome length.}

\item{...}{Additional arguments passed to \code{\link[graphics:segments]{graphics::segments()}}}
}
\value{
None.
}
\description{
Draw line segments at significance thresholds for a genome scan plot
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c(3,15,"X")]}
map <- insert_pseudomarkers(iron$gmap, step=5)
probs <- calc_genoprob(iron, map, error_prob=0.002)
Xcovar <- get_x_covar(iron)
out <- scan1(probs, iron$pheno[,1], Xcovar=Xcovar)
# run just 3 permutations, as a fast illustration
operm <- scan1perm(probs, iron$pheno[,1], addcovar=Xcovar,
                   n_perm=3, perm_Xsp=TRUE, chr_lengths=chr_lengths(map))

plot(out, map)
add_threshold(map, summary(operm), col="violetred", lty=2)
}
