% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_cross2.R
\name{subset.cross2}
\alias{subset.cross2}
\alias{[.cross2}
\title{Subsetting data for a QTL experiment}
\usage{
\method{subset}{cross2}(x, ind = NULL, chr = NULL, ...)

\method{[}{cross2}(x, ind = NULL, chr = NULL)
}
\arguments{
\item{x}{An object of class \code{"cross2"}, as output by \code{\link[=read_cross2]{read_cross2()}}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{ind}{A vector of individuals: numeric indices, logical
values, or character string IDs.}

\item{chr}{A vector of chromosomes: numeric indices, logical
values, or character string IDs}

\item{...}{Ignored.}
}
\value{
The input \code{cross2} object, with the selected
individuals and/or chromsomes.
}
\description{
Pull out a specified set of individuals and/or chromosomes from a
\code{cross2} object.
}
\details{
When subsetting by individual, if \code{ind} is numeric, they're
assumed to be numeric indices; if character strings, they're
assumed to be individual IDs. \code{ind} can be numeric or logical
only if the genotype, phenotype, and covariate data all have the
same individuals in the same order.

When subsetting by chromosome, \code{chr} is \emph{always}
converted to character strings and treated as chromosome IDs. So if
there are three chromosomes with IDs \code{"18"}, \code{"19"}, and
\code{"X"}, \code{mycross[,18]} will give the first of the
chromosomes (labeled \code{"18"}) and \code{mycross[,3]} will give
an error.

When using character string IDs for \code{ind} or \code{chr}, you
can use "negative" subscripts to indicate exclusions, for example
\code{mycross[,c("-18", "-X")]} or \code{mycross["-Mouse2501",]}.
But you can't mix "positive" and "negative" subscripts, and if any
of the individuals has an ID that begins with \code{"-"}, you can't
use negative subscripts like this.
}
\section{Warning}{

The order of the two arguments is reversed relative to the related
function in \href{https://rqtl.org}{R/qtl}.
}

\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
# keep individuals 1-20 and chromosomes 3 and 4
grav2sub <- grav2[1:20, c(3,4)]
# keep just chromosome 1
grav2_c1 <- grav2[,1]
}
\keyword{utilities}
