% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probs_qtl2_to_array.R
\name{probs_qtl2_to_array}
\alias{probs_qtl2_to_array}
\title{Convert R/qtl2 genotype probabilities to a 3d array}
\usage{
probs_qtl2_to_array(probs)
}
\arguments{
\item{probs}{A \code{"calc_genoprob"} object (a list of 3d arrays of
genotype probabilities), as calculated by \code{\link[qtl2:calc_genoprob]{qtl2::calc_genoprob()}}.}
}
\value{
A single three-dimensional array, with just the autosomal
genotype probabilities.
}
\description{
Convert R/qtl2 genotype probabilities to a 3d array
}
\details{
We convert just the autosomal genotype probabilities, because they
should all have the same number of genotypes (columns). The main
application of this is for identifying possible sample mix-ups
among batches of genotype probabilities (e.g., using the
\href{https://github.com/kbroman/lineup2}{R/lineup2} package), and for
this the autosomal genotype probabilities should be sufficient.
}
