% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurveys.R
\name{getSurveys}
\alias{getSurveys}
\title{Retrieve a data frame of all active surveys on Qualtrics}
\usage{
getSurveys()
}
\description{
Retrieve a data frame of all active surveys on Qualtrics
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
registerOptions(api_token="<YOUR-API-TOKEN>", root_url="<YOUR-ROOT-URL>")
# Retrieve a list of surveys
surveys <- getSurveys()
# Retrieve a single survey
mysurvey <- getSurvey(surveyID = surveys$id[6],
                      save_dir = tempdir(),
                      verbose=TRUE)
# You can use the same parameters as those found in the qualtrics API documentation
# Found here: https://api.qualtrics.com/docs/csv
mysurvey <- getSurvey(surveyID = surveys$id[6],
                      save_dir = tempdir(),
                      startDate = "2017-01-01",
                      endDate = "2017-01-31",
                      limit = 100,
                      useLabels = TRUE,
                      seenUnansweredRecode = "UNANS",
                      verbose=TRUE)
}
}
\seealso{
See \url{https://api.qualtrics.com/docs} for documentation on the Qualtrics API.
}
\author{
Jasper Ginn
}
