% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_map.R
\name{column_map}
\alias{column_map}
\title{Retrieve a data frame containing survey column mapping}
\usage{
column_map(surveyID)
}
\arguments{
\item{surveyID}{A string. Unique ID for the survey you want to download.
Returned as \code{id} by the \link[=all_surveys]{all_surveys} function.}
}
\description{
Retrieve a data frame containing survey column mapping
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve column mapping for a survey
mapping <- column_map(surveyID = surveys$id[6])

# Retrieve a single survey, filtering for specific questions
mysurvey <- fetch_survey(
  surveyID = surveys$id[6],
  save_dir = tempdir(),
  include_questions = c("QID1", "QID2", "QID3"),
  verbose = TRUE
)
}

}
\seealso{
See \url{https://api.qualtrics.com/} for documentation on the
Qualtrics API.
}
