% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{data_corpus_moviereviews}
\alias{data_corpus_moviereviews}
\title{Movie reviews with polarity from Pang and Lee (2004)}
\format{The corpus includes the following document variables: \describe{
\item{sentiment}{factor indicating whether a review was manually classified as
positive \code{pos} or negative \code{neg}.}
\item{id1}{Character counting the position in the corpus.}
\item{id2}{Random number for each review.}
}}
\source{
\url{https://www.cs.cornell.edu/people/pabo/movie-review-data/}
}
\usage{
data_corpus_moviereviews
}
\description{
A corpus object containing 2,000 movie reviews classified by positive or negative sentiment.
}
\details{
For more information, see \code{cat(meta(data_corpus_moviereviews, "readme"))}.
}
\examples{
# check polarities
table(data_corpus_moviereviews$sentiment)

# make the data into sentences, because each line is a sentence
data_corpus_moviereviewsents <-
    quanteda::corpus_segment(data_corpus_moviereviews, "\n", extract_pattern = FALSE)
print(data_corpus_moviereviewsents, max_ndoc = 3)
}
\references{
Pang, B., Lee, L.  (2004)
"\href{https://www.cs.cornell.edu/home/llee/papers/cutsent.pdf}{A Sentimental
Education: Sentiment Analysis Using Subjectivity Summarization Based on
Minimum Cuts.}", Proceedings of the ACL.
}
\keyword{data}
