% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_dist.R
\name{as.list.dist}
\alias{as.list.dist}
\title{coerce a dist object into a list}
\usage{
\method{as.list}{dist}(x, sorted = TRUE, n = NULL, ...)
}
\arguments{
\item{x}{dist class object}

\item{sorted}{sort results in descending order if \code{TRUE}}

\item{n}{the top \code{n} highest-ranking items will be returned.  If n is 
\code{NULL}, return all items.}

\item{...}{unused}
}
\description{
Coerce a dist matrix into a list of selected terms and tarhet terms in
descending order.  Can be used after calling \code{\link{textstat_simil}} or
\code{\link{textstat_dist}}.
}
\examples{
\dontrun{
## compare to tm

# tm version
require(tm)
data("crude")
crude <- tm_map(crude, content_transformer(tolower))
crude <- tm_map(crude, removePunctuation)
crude <- tm_map(crude, removeNumbers)
crude <- tm_map(crude, stemDocument)
tdm <- TermDocumentMatrix(crude)
findAssocs(tdm, c("oil", "opec", "xyz"), c(0.75, 0.82, 0.1))

# in quanteda
quantedaDfm <- new("dfmSparse", Matrix::Matrix(t(as.matrix(tdm))))
as.list(textstat_simil(quantedaDfm, c("oil", "opec", "xyz"), margin = "features", n = 14))

# in base R
corMat <- as.matrix(proxy::simil(as.matrix(quantedaDfm), by_rows = FALSE))
round(head(sort(corMat[, "oil"], decreasing = TRUE), 14), 2)
round(head(sort(corMat[, "opec"], decreasing = TRUE), 9), 2)
} 
}

