% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_wordshoal.R
\name{textmodel_wordshoal}
\alias{textmodel_wordshoal}
\title{wordshoal text model}
\usage{
textmodel_wordshoal(x, groups, authors, dir = c(1, 2), tol = 0.001)
}
\arguments{
\item{x}{the \link{dfm} from which the model will be fit}

\item{groups}{the name of a variable in the document variables for data
giving the document group for each document}

\item{authors}{the name of a variable in the document variables for data
giving the author of each document}

\item{dir}{set global identification by specifying the indexes for a pair of 
authors such that \eqn{\hat{\theta}_{dir[1]} < \hat{\theta}_{dir[2]}}}

\item{tol}{a convergence threshold for the
log-posterior of the model}
}
\value{
An object of class textmodel_fitted_wordshoal.  This is a list 
  containing: \item{tol}{log-posterior tolerance used in fitting} 
  \item{dir}{global identification of the dimension} \item{theta}{estimated
  document positions} \item{beta}{debate marginal effects} 
  \item{alpha}{estimated document fixed effects} \item{psi}{estimated
  document debate-level positions} \item{groups}{document groups} 
  \item{authors}{document authors} \item{ll}{log likelihood at convergence} 
  \item{se.theta}{standard errors for theta-hats} \item{data}{corpus to which
  the model was fit}
}
\description{
Estimate Lauderdale and Herzog's (2016) model for one-dimensional document
author (e.g. speakers) positions based on multiple groups of texts (e.g.
debates).  Each group of texts is scaled using Slapin and Proksch's (2008)
"wordfish" Poisson scaling model of one-dimensional document positions, and
then the positions from a particular author are scaled across groups using a
second-level linear factor model, using conditional maximum likelihood.
}
\details{
Returns estimates of relative author positions across the full
  corpus of texts.
}
\examples{
\dontrun{
data(data_corpus_irish30, package = "quantedaData")
iedfm <- dfm(data_corpus_irish30, remove_punct = TRUE)
wordshoalfit <- 
    textmodel_wordshoal(iedfm, dir = c(7,1),
                        groups = docvars(data_corpus_irish30, "debateID"), 
                        authors = docvars(data_corpus_irish30, "member.name"))
fitdf <- merge(as.data.frame(summary(wordshoalfit)),
               docvars(data_corpus_irish30), 
               by.x = "row.names", by.y = "member.name")
fitdf <- subset(fitdf, !duplicated(memberID))
aggregate(theta ~ party.name, data = fitdf, mean)
}
}
\references{
Benjamin E. Lauderdale and Alexander Herzog.  2016.
  "\href{https://www.cambridge.org/core/journals/political-analysis/article/measuring-political-positions-from-legislative-speech/35D8B53C4B7367185325C25BBE5F42B4}{Measuring
   Political Positions from Legislative Speech}." \emph{Political Analysis}
  24 (3, July): 374-394.
}
\author{
Benjamin Lauderdale and Kenneth Benoit
}
\keyword{experimental}
\keyword{textmodel}
