% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsyllable.R
\name{nsyllable}
\alias{nsyllable}
\title{count syllables in a text}
\usage{
nsyllable(x, syllable_dictionary = quanteda::data_int_syllables,
  use.names = FALSE)
}
\arguments{
\item{x}{character vector or \code{tokens} object  whose 
syllables will be counted}

\item{syllable_dictionary}{optional named integer vector of syllable counts where 
the names are lower case tokens.  When set to \code{NULL} (default), then 
the function will use the quanteda data object \code{data_int_syllables}, an 
English pronunciation dictionary from CMU.}

\item{use.names}{logical; if \code{TRUE}, assign the tokens as the names of 
the syllable count vector}
}
\value{
If \code{x} is a character vector, a named numeric vector of the 
  counts of the syllables in each element.  If \code{x} is a \link{tokens}
  object, return a list of syllable counts where each list element corresponds
  to the tokens in a document.
}
\description{
Returns a count of the number of syllables in texts. For English
  words, the syllable count is exact and looked up from the CMU pronunciation
  dictionary, from the default syllable dictionary \code{data_int_syllables}. 
  For any word not in the dictionary, the syllable count is estimated by 
  counting vowel clusters.
  
  \code{data_int_syllables} is a quanteda-supplied data object consisting of a 
  named numeric vector of syllable counts for the words used as names.  This 
  is the default object used to count English syllables.  This object that 
  can be accessed directly, but we strongly encourage you to access it only 
  through the \code{nsyllable()} wrapper function.
}
\note{
All tokens are automatically converted to lowercase to perform the
  matching with the syllable dictionary, so there is no need to perform this
  step prior to calling \code{nsyllable()}.
}
\examples{
# character
nsyllable(c("cat", "syllable", "supercalifragilisticexpialidocious", 
            "Brexit", "Administration"), use.names = TRUE)

# tokens
txt <- c(doc1 = "This is an example sentence.",
         doc2 = "Another of two sample sentences.")
nsyllable(tokens(txt, remove_punct = TRUE))
# punctuation is not counted
nsyllable(tokens(txt), use.names = TRUE)
}
