% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_weight.R
\name{docfreq}
\alias{docfreq}
\title{Compute the (weighted) document frequency of a feature}
\usage{
docfreq(x, scheme = c("count", "inverse", "inversemax", "inverseprob",
  "unary"), smoothing = 0, k = 0, base = 10, threshold = 0,
  use.names = TRUE)
}
\arguments{
\item{x}{a \link{dfm}}

\item{scheme}{type of document frequency weighting, computed as
follows, where \eqn{N} is defined as the number of documents in the dfm and
\eqn{s} is the smoothing constant:
\describe{
\item{\code{count}}{\eqn{df_j}, the number of documents for which \eqn{n_{ij} > threshold}}
\item{\code{inverse}}{\deqn{\textrm{log}_{base}\left(s + \frac{N}{k + df_j}\right)}}
\item{\code{inversemax}}{\deqn{\textrm{log}_{base}\left(s + \frac{\textrm{max}(df_j)}{k + df_j}\right)}}
\item{\code{inverseprob}}{\deqn{\textrm{log}_{base}\left(\frac{N - df_j}{k + df_j}\right)}}
\item{\code{unary}}{1 for each feature}
}}

\item{smoothing}{added to the quotient before taking the logarithm}

\item{k}{added to the denominator in the "inverse" weighting types, to 
prevent a zero document count for a term}

\item{base}{the base with respect to which logarithms in the inverse document
frequency weightings are computed; default is 10 (see Manning, 
  Raghavan, and Schutze 2008, p123).}

\item{threshold}{numeric value of the threshold \emph{above which} a feature 
will considered in the computation of document frequency.  The default is 
0, meaning that a feature's document frequency will be the number of 
documents in which it occurs greater than zero times.}

\item{use.names}{logical; if \code{TRUE} attach feature labels as names of 
the resulting numeric vector}

\item{...}{not used}
}
\value{
a numeric vector of document frequencies for each feature
}
\description{
For a \link{dfm} object, returns a (weighted) document frequency for each
term.  The default is a simple count of the number of documents in which a
feature occurs more than a given frequency threshold.  (The default threshold
is  zero, meaning that any feature occurring at least once in a document will
be counted.)
}
\examples{
mydfm <- dfm(data_corpus_inaugural[1:2])
docfreq(mydfm[, 1:20])

# replication of worked example from
# https://en.wikipedia.org/wiki/Tf-idf#Example_of_tf.E2.80.93idf
wiki_dfm <- 
    matrix(c(1,1,2,1,0,0, 1,1,0,0,2,3),
           byrow = TRUE, nrow = 2,
           dimnames = list(docs = c("document1", "document2"),
                           features = c("this", "is", "a", "sample",
                                        "another", "example"))) \%>\%
    as.dfm()
wiki_dfm
docfreq(wiki_dfm)
docfreq(wiki_dfm, scheme = "inverse")
docfreq(wiki_dfm, scheme = "inverse", k = 1, smoothing = 1)
docfreq(wiki_dfm, scheme = "unary")
docfreq(wiki_dfm, scheme = "inversemax")
docfreq(wiki_dfm, scheme = "inverseprob")
}
\references{
Manning, C. D., Raghavan, P., & Schutze, H. (2008). 
  \emph{Introduction to Information Retrieval}. Cambridge University Press.
}
\keyword{dfm}
\keyword{weighting}
