% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_group.R
\name{tokens_group}
\alias{tokens_group}
\title{Recombine documents tokens by groups}
\usage{
tokens_group(x, groups = NULL, fill = FALSE)
}
\arguments{
\item{x}{\link{tokens} object}

\item{groups}{either: a character vector containing the names of document
variables to be used for grouping; or a factor or object that can be
coerced into a factor equal in length or rows to the number of documents.
\code{NA} values of the grouping value are dropped.
See \link{groups} for details.}
}
\description{
Recombine documents tokens by groups
}
\examples{
# dfm_group examples
corp <- corpus(c("a a b", "a b c c", "a c d d", "a c c d"),
                   docvars = data.frame(grp = c("grp1", "grp1", "grp2", "grp2")))
toks <- tokens(corp)
quanteda:::tokens_group(toks, groups = "grp")
quanteda:::tokens_group(toks, groups = c(1, 1, 2, 2))
quanteda:::tokens_group(toks, groups = factor(c(1, 1, 2, 2), levels = 1:3))
}
\keyword{internal}
\keyword{tokens}
