% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{flatten_dictionary}
\alias{flatten_dictionary}
\title{Flatten a hierarchical dictionary into a list of character vectors}
\usage{
flatten_dictionary(
  dict,
  levels = 1:100,
  level = 1,
  key_parent = "",
  dict_flat = list()
)
}
\arguments{
\item{dict}{internal argument to pass flattened dictionary}

\item{levels}{integer vector indicating levels in the dictionary}

\item{level}{internal argument to pass current levels}

\item{tree}{list to be flattened}

\item{key_tree}{internal argument to pass for parent keys}
}
\value{
A dictionary flattened to variable levels
}
\description{
Converts a hierarchical dictionary (a named list of named lists, ending in
character vectors at the lowest level) into a flat list of character
vectors. Works like \code{unlist(dictionary, recursive=TRUE)} except that
the recursion does not go to the bottom level.  Called by \code{\link[=dfm]{dfm()}}.
}
\examples{
dict1 <-
    dictionary(list(populism=c("elit*", "consensus*", "undemocratic*", "referend*",
                               "corrupt*", "propagand", "politici*", "*deceit*",
                               "*deceiv*", "*betray*", "shame*", "scandal*", "truth*",
                               "dishonest*", "establishm*", "ruling*")))
flatten_dictionary(dict1)

dict2 <- list(level1a = list(level1a1 = c("l1a11", "l1a12"),
                            level1a2 = c("l1a21", "l1a22")),
             level1b = list(level1b1 = c("l1b11", "l1b12"),
                             level1b2 = c("l1b21", "l1b22", "l1b23")),
              level1c = list(level1c1a = list(level1c1a1 = c("lowest1", "lowest2")),
                             level1c1b = list(level1c1b1 = c("lowestalone"))))
flatten_dictionary(dict2)
flatten_dictionary(dict2, 2)
flatten_dictionary(dict2, 1:2)
}
\author{
Kohei Watanabe
}
\keyword{dictionary}
\keyword{internal}
