% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacyr-methods.R
\name{spacyr-methods}
\alias{spacyr-methods}
\alias{docnames.spacyr_parsed}
\alias{ndoc.spacyr_parsed}
\alias{ntoken.spacyr_parsed}
\alias{ntype.spacyr_parsed}
\alias{nsentence.spacyr_parsed}
\title{Extensions for and from spacy_parse objects}
\usage{
\method{docnames}{spacyr_parsed}(x)

\method{ndoc}{spacyr_parsed}(x)

\method{ntoken}{spacyr_parsed}(x, ...)

\method{ntype}{spacyr_parsed}(x, ...)

\method{nsentence}{spacyr_parsed}(x, ...)
}
\arguments{
\item{x}{an object returned by \code{spacy_parse}, or (for
\code{spacy_parse}) a \link{corpus} object}

\item{...}{not used for these functions}
}
\description{
These functions provide \pkg{quanteda} methods for \pkg{spacyr} objects, and
also extend \link[spacyr:spacy_parse]{spacy_parse} and
\link[spacyr:spacy_tokenize]{spacy_tokenize} to work directly with \link{corpus}
objects.
}
\details{
\code{spacy_parse(x, ...)} and \code{spacy_tokenize(x, ...)} work directly on
\pkg{quanteda} \link{corpus} objects.

\code{docnames()} returns the document names

\code{ndoc()} returns the number of documents

\code{ntoken()} returns the number of tokens by document

\code{ntype()} returns the number of types (unique tokens) by document

\code{nsentence()} returns the number of sentences by document
}
\examples{
\dontrun{
library("spacyr")
spacy_initialize()

corp <- corpus(c(doc1 = "And now, now, now for something completely different.",
                 doc2 = "Jack and Jill are children."))
spacy_tokenize(corp)
(parsed <- spacy_parse(corp))

ntype(parsed)
ntoken(parsed)
ndoc(parsed)
docnames(parsed)
}
}
