% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_trim.R
\name{tokens_trim}
\alias{tokens_trim}
\title{Trim tokens using frequency threshold-based feature selection}
\usage{
tokens_trim(
  x,
  min_termfreq = NULL,
  max_termfreq = NULL,
  termfreq_type = c("count", "prop", "rank", "quantile"),
  min_docfreq = NULL,
  max_docfreq = NULL,
  docfreq_type = c("count", "prop", "rank", "quantile"),
  padding = FALSE,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{min_termfreq, max_termfreq}{minimum/maximum values of feature frequencies
across all documents, below/above which features will
be removed}

\item{termfreq_type}{how \code{min_termfreq} and \code{max_termfreq} are
interpreted.  \code{"count"} sums the frequencies; \code{"prop"} divides the
term frequencies by the total sum; \code{"rank"} is matched against the
inverted ranking of features in terms of overall frequency, so that 1, 2,
... are the highest and second highest frequency features, and so on;
\code{"quantile"} sets the cutoffs according to the quantiles (see
\code{\link[=quantile]{quantile()}}) of term frequencies.}

\item{min_docfreq, max_docfreq}{minimum/maximum values of a feature's document
frequency, below/above which features will be removed}

\item{docfreq_type}{specify how \code{min_docfreq} and \code{max_docfreq} are
interpreted.   \code{"count"} is the same as \verb{[docfreq](x, scheme = "count")}; \code{"prop"} divides the document frequencies by the total
sum; \code{"rank"} is matched against the inverted ranking of document
frequency, so that 1, 2, ... are the features with the highest and second
highest document frequencies, and so on; \code{"quantile"} sets the cutoffs
according to the quantiles (see \code{\link[=quantile]{quantile()}}) of document
frequencies.}

\item{padding}{if \code{TRUE}, leave an empty string where the removed tokens
previously existed.}

\item{verbose}{if \code{TRUE} print the number of tokens and documents before and
after the function is applied. The number of tokens does not include paddings.}
}
\value{
A \link{tokens} object with reduced size.
}
\description{
Returns a tokens object reduced in size based on
document and term frequency, usually in terms of a minimum frequency, but
may also be in terms of maximum frequencies.  Setting a combination of
minimum and maximum frequencies will select features based on a range.
}
\examples{
toks <- tokens(data_corpus_inaugural)

# keep only words occurring >= 10 times and in >= 2 documents
tokens_trim(toks, min_termfreq = 10, min_docfreq = 2, padding = TRUE)

# keep only words occurring >= 10 times and no more than 90\% of the documents
tokens_trim(toks, min_termfreq = 10, max_docfreq = 0.9, docfreq_type = "prop",
            padding = TRUE)

}
\seealso{
\code{\link[=dfm_trim]{dfm_trim()}}
}
