% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/aux-functions.R
\name{frequenciesValidator}
\alias{frequenciesValidator}
\title{Validates if frequencies are Fourier frequencies from
\eqn{[0,\pi]}{[0,pi]}.}
\usage{
frequenciesValidator(freq, N, steps = 1:6)
}
\arguments{
\item{freq}{the vector of frequencies to be validated.}

\item{N}{the base of the Fourier frequencies against which the values in
\code{freq} will be compared.}

\item{steps}{a vector containing a subset of {1,2,3,4,5,6}, indicating
             which of the steps are to be performed.}
}
\value{
Returns a vector of Fourier frequencies that is yield by the
        transformations described above.
}
\description{
Validation of the parameter \code{freq} is perfomed in six steps:
\enumerate{
\item Throw an error if parameter is not a vector or not numeric.
\item Transform each element \eqn{\omega}{w} of the vector to
           \eqn{[0,2\pi)}{[0,2pi)}, by replacing it with
           \eqn{\omega \, \mbox{mod} \, 2\pi}{w mod 2pi}.
\item Check whether all elements \eqn{\omega}{w} of the vector are
           Fourier frequency \eqn{2 \pi j / T}{2 pi j / T}, \eqn{j \in Z}.
           If this is not
           the case issue a warning and round each frequency to the next
           Fourier frequency of the mentioned type; the smaller one, if
           there are two.
\item Transform each element \eqn{\omega}{w} with
           \eqn{\pi < \omega < 2\pi}{pi < w < 2pi} of the vector to
           \eqn{[0,\pi]}{[0,pi]}, by replacing it with
           \eqn{2\pi - \omega}{2pi - w}.
\item Check for doubles and remove all but the first appearance.
\item Sort in ascending order.
}
Any subset of the six steps can be chosen, but 1 should almost always be
among the steps to be performed.
}
\examples{
freq <- 2*pi*c(3,2,5,8,9)/10

res <- frequenciesValidator(freq, N=10, steps=1:3)
res * 10 / (2*pi) # Returns: [1] 3 2 5 8 9

res <- frequenciesValidator(freq, N=10, steps=1:4)
res * 10 / (2*pi) # Returns: [1] 3 2 5 2 1

res <- frequenciesValidator(freq, N=10, steps=1:5)
res * 10 / (2*pi) # Returns: [1] 3 2 5 1

res <- frequenciesValidator(freq, N=10, steps=1:6)
res * 10 / (2*pi) # Returns: [1] 1 2 3 5
}
\keyword{Validator-functions}

