% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SpecDistrWeight.R
\name{plot-SpecDistrWeight}
\alias{plot-SpecDistrWeight}
\alias{plot,SpecDistrWeight,missing-method}
\title{Plot the values of the \code{\link{SpecDistrWeight}}.}
\usage{
\S4method{plot}{SpecDistrWeight,missing}(
  x,
  y,
  ylab = expression(W[n](omega)),
  xlab = expression(omega),
  main = x@descr,
  ...
)
}
\arguments{
\item{x}{The \code{\link{SpecDistrWeight}} to plot.}

\item{y}{missing arg from the generic; will be ignored.}

\item{ylab}{label for the y-axis; optional}

\item{xlab}{label for the x-axis; optional}

\item{main}{titel (on top) of the plot; optional}

\item{...}{optional parameters used for plotting}
}
\value{
Plots the \code{\link{SpecDistrWeight}}.
}
\description{
Creates a plot visualizing the weights \eqn{W_n(\omega)}
[cf. \code{\link{SpecDistrWeight-class}}] that are used to estimate the
integrated quantile spectral density.
}
\details{
In the plot the values at the frequencies
\eqn{2\pi j / 128}, \eqn{j=-63,\ldots,64} are shown.
}
\examples{
plot(specDistrWeight(),
       ylab=expression(W[n](x)),
       xlab=expression(x))
}
