% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{.gtheory}
\alias{.gtheory}
\title{Bootstrap Function for \code{gtheory()} Function}
\usage{
.gtheory(dat, i, cross.vrb)
}
\arguments{
\item{dat}{data.frame with only the variables/items you wish to include in
the generalizability theory coefficient and no other variables/items.}

\item{i}{integer vector of length = \code{nrow(dat)} specifying which rows
should be included in the computation. When used by the \code{boot::boot}
function this argument will change with every new bootstrapped resample.}

\item{cross.vrb}{logical vector of length 1 specifying whether the
variables/items should be crossed when computing the generalizability
theory coefficient. If TRUE, then only the covariance structure of the
variables/items will be incorperated into the estimate of reliability. If
FALSE, then the mean structure of the variables/items will be incorperated.}
}
\value{
double vector of length 1 providing the generalizability theory
  coefficient.
}
\description{
\code{.gtheory} is the function used by the \code{\link[boot]{boot}} function
within the \code{\link{gtheory}} function. It is primarily created to
increase the computational efficiency of bootstrap confidence intervals
within the \code{gtheory} function by doing only the minimal computations
needed to compute the generalizability theory coefficient.
}
\examples{
.gtheory(dat = attitude,
   i = sample(x = 1:nrow(attitude), size = nrow(attitude), replace = TRUE),
   cross.vrb = TRUE)
.gtheory(dat = attitude,
   i = sample(x = 1:nrow(attitude), size = nrow(attitude), replace = TRUE),
   cross.vrb = FALSE)
}
\seealso{
\code{\link{.gtheorys}}
   \code{\link{gtheory}}
}
