% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{means_change}
\alias{means_change}
\title{Mean Changes Across Two Timepoints For Multiple PrePost Pairs of Variables
(dependent two-samples t-tests)}
\usage{
means_change(
  data,
  prepost.nm.list,
  standardizer = "pre",
  d.ci.type = "unbiased",
  ci.level = 0.95,
  check = TRUE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{prepost.nm.list}{list of length-2 character vectors specifying the
colnames from \code{data} corresponding to the prepost pairs of variables.
For each element of the list, the character vector should have length 2
where the first element corresponds to the pre-timepoint variable colname
of that prepost pair and the second element corresponds to the
post-timepoint variable colname of that prepost pair. The names of the list
will be the rownames in the data.frames of the return object. See examples.
\code{prepost.nm.list} can also be a single length-2 character vector for
the case of a single pre-post pair of variables, which is functionally
equivalent to \code{\link{mean_change}}.}

\item{standardizer}{chararacter vector of length 1 specifying what to use for
standardization when computing the standardized mean difference (i.e.,
Cohen's d). There are three options: 1. "pre" for the standard deviation of
the pre-timepoint, 2. "pooled" for the pooled standard deviation of the
pre-timepoint and post-timepoint, 3. "change" for the standard deviation of
the change score (post - pre). The default is "pre", which I believe makes
the most theoretical sense (see Cumming, 2012); however, "change" is the
traditional choice originally proposed by Jacob Cohen (Cohen, 1988).}

\item{d.ci.type}{character vector of lenth 1 specifying how to compute the
confidence intervals (and standard errors) of the standardized mean
differences. There are currently two options: 1. "unbiased" which
calculates the unbiased standard error of Cohen's d based on the formulas
in Viechtbauer (2007). If \code{standardizer} = "pre" or "pooled", then
equation 36 from Table 2 is used. If \code{standardizer} = "change", then
equation 25 from Table 1 is used. A symmetrical confidence interval is then
calculated based on the standard error. 2. "classic" which calculates the
confidence interval of Cohen's d based on the confidence interval of the
mean change itself. The lower and upper confidence bounds are divided by
the \code{standardizer}. Technically, this confidence interval is biased
due to not taking into account the uncertainty of the \code{standardizer}.
No standard error is calculated for this option and NA is returned for
"d_se" in the return object.}

\item{ci.level}{double vector of length 1 specifying the confidence level.
\code{ci.level} must range from 0 to 1.}

\item{check}{logical vector of length 1 specifying whether the input
arguments should be checked for errors. For example, checking whether
\code{prepost.nm.list} is a list of length-2 character vectors. This is a
tradeoff between computational efficiency (FALSE) and more useful error
messages (TRUE).}
}
\value{
list of data.frames containing statistical information about the mean
  change for each prepost pair of variables (the rownames of the data.frames
  are the names of \code{prepost.nm.list}): 1) nhst = dependent two-samples
  t-test stat info in a data.frame, 2) desc = descriptive statistics stat info
  in a data.frame, 3) std = standardized mean difference stat info in a data.frame,


1) nhst = dependent two-samples t-test stat info in a data.frame

\describe{
   \item{est}{mean change estimate (i.e., post - pre)}
   \item{se}{standard error}
   \item{t}{t-value}
   \item{df}{degrees of freedom}
   \item{p}{two-sided p-value}
   \item{lwr}{lower bound of the confidence interval}
   \item{upr}{upper bound of the confidence interval}
}

2) desc = descriptive statistics stat info in a data.frame

\describe{
   \item{mean_post}{mean of the post variable}
   \item{mean_pre}{mean of the pre variable}
   \item{sd_post}{standard deviation of of the post variable}
   \item{sd_pre}{standard deviation of the pre variable}
   \item{n}{sample size of the change score}
   \item{r}{Pearson correlation between the pre and post variables}
}

3) std = standardized mean difference stat info in a data.frame

\describe{
   \item{d_est}{Cohen's d estimate}
   \item{d_se}{Cohen's d standard error}
   \item{d_lwr}{Cohen's d lower bound of the confidence interval}
   \item{d_upr}{Cohen's d upper bound of the confidence interval}
}
}
\description{
\code{means_change} tests for mean changes across two timepoints for multiple
prepost pairs of variables via dependent two-samples t-tests. The function
also calculates the descriptive statistics for the timepoints and the
standardized mean differences (i.e., Cohen's d) based on either the standard
deviation of the pre-timepoint, pooled standard deviation of the
pre-timepoint and post-timepoint, or the standard deviation of the change
score (post - pre). \code{means_change} is simply a wrapper for
\code{\link[stats]{t.test}} plus some extra calculations.
}
\details{
For each prepost pair of variables, \code{means_change} calculates the mean
change as \code{data[[ prepost.nm.list[[i]][2] ]]} - \code{data[[
prepost.nm.list[[i]][1] ]]} (which corresponds to post - pre) such that
increases over time have a positive mean change estimate and decreases over
time have a negative mean change estimate. This would be as if the
post-timepoint was \code{x} and the pre-timepoint \code{y} in
\code{t.test(paired = TRUE)}.
}
\examples{

# dependent two-sample t-tests
prepost_nm_list <- list("first_pair" = c("disp","hp"), "second_pair" = c("carb","gear"))
means_change(mtcars, prepost.nm.list = prepost_nm_list)
means_change(mtcars, prepost.nm.list = prepost_nm_list, d.ci.type = "classic")
means_change(mtcars, prepost.nm.list = prepost_nm_list, standardizer = "change")
means_change(mtcars, prepost.nm.list = prepost_nm_list, ci.level = 0.99)

# same as intercept-only regression with the change score
means_change(data = mtcars, prepost.nm.list = c("disp","hp"))
lm_obj <- lm(hp - disp ~ 1, data = mtcars)
coef(summary(lm_obj))

}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences,
   2nd ed. Hillsdale, NJ: Erlbaum.

   Cumming, G. (2012). Understanding the new statistics: Effect sizes,
   confidence intervals, and meta-analysis. New York, NY: Rouledge.

   Viechtbauer, W. (2007). Approximate confidence intervals for standardized
   effect sizes in the two-independent and two-dependent samples design.
   Journal of Educational and Behavioral Statistics, 32(1), 39-60.
}
\seealso{
\code{\link{mean_change}} for a single pair of prepost variables,
   \code{\link[stats]{t.test}} fixes the table of contents for some unknown reason,
   \code{\link{means_diff}} for multiple independent two-sample t-tests,
   \code{\link{means_test}} for multiple one-sample t-tests,
}
