% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pkg.R
\name{create_pkg}
\alias{create_pkg}
\alias{create_pkg}
\alias{create_vignette}
\alias{create_data_raw}
\title{Create Package}
\usage{
create_pkg(path, use_data_raw = FALSE, ci = NULL, rstudio = FALSE, ...)

create_vignette(name, path = ".")

create_data_raw(path = ".")
}
\arguments{
\item{path}{location to create a new package.  The last component of the path
will be used as the package name.}

\item{use_data_raw}{logical (default \code{FALSE}), if \code{TRUE} then data
and data-raw directories are created.}

\item{ci}{when set to \code{travis} of \code{gitlab} will place
the needed template files into the top level of the package skeleton.}

\item{rstudio}{passed to \code{\link[devtools]{create}}.  devtools sets the
default to \code{TRUE} but \code{create_pkg} sets the default to \code{FALSE}
since I don't use RStudio.}

\item{...}{additional arguments passed to \code{\link[devtools]{create}}}

\item{name}{the name of the vigenette}
}
\description{
A wrapper about \code{\link[devtools]{create}} for creating R package
skeletons.
}
\details{
Based on the \code{\link[devtools]{create}} function from devtools, this
function will create a package skeleton with directories for R files, and
examples.

Common files are also added to the project root directory:
\itemize{
  \item CONTRIBUTING.md
  \item DESCRIPTION
  \item NAMESPACE
  \item NEWS.md
  \item README.md
  \item .gitignore
  \item .Rbuildignore
  \item makefile
}

If data will be used in the package set \code{use_data_raw = TRUE} when
creating the package skeleton, or use \code{create_data_raw()} after the
initial package skeleton is created to add the data and data-raw directories.

Template files for CI via travis and gitlab runners are in the template
directtory. Setting \code{ci} to \code{travis} of \code{gitlab} will place
the needed template files into the top level of the package skeleton.
}
\examples{
\dontrun{ 
  # Package without the data directories
  path <- file.path(tempdir(), "myDefaultPackage")
  create_pkg(path)
  unlink(path, recursive = TRUE)
   
  # Package with data directories 
  create_pkg(path, use_data_raw = TRUE) 
}

# View all the template files
system.file("templates", package = "qwraps2")
}
