% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dt_Function.R
\name{r2dt}
\alias{r2dt}
\title{R Squared Difference Test (R2DT). Test for a statistically significant difference in generalized explained variance between two candidate models.}
\usage{
r2dt(x, y = NULL, cor = TRUE, fancy = FALSE, onesided = TRUE,
  clim = 95, nsims = 2000, mu = NULL)
}
\arguments{
\item{x}{An R2 object from the r2beta function.}

\item{y}{An R2 object from the r2beta function. If y is not specified, Ho: E[x] = mu is tested (mu is specified by the user).}

\item{cor}{if TRUE, the R squared statistics are assumed to be positively correlated and a simulation based approach is used. If FALSE, the R squared are assumed independent and the difference of independent beta distributions is used. This only needs to be specified when two R squared measures are being considered.}

\item{fancy}{if TRUE, the output values are rounded and changed to characters.}

\item{onesided}{if TRUE, the alternative hypothesis is that one model explains a larger proportion of generalized variance. If false, the alternative is that the amount of generalized variance explained by the two candidate models is not equal.}

\item{clim}{Desired confidence level for interval estimates regarding the difference in generalized explained variance.}

\item{nsims}{number of samples to draw when simulating correlated non-central beta random variables. This parameter is only relevant if cor=TRUE.}

\item{mu}{Used to test Ho: E[x] = mu.}
}
\value{
A confidence interval for the difference in R Squared statistics and a p-value corresponding to the null hypothesis of no difference.
}
\description{
R Squared Difference Test (R2DT). Test for a statistically significant difference in generalized explained variance between two candidate models.
}
\examples{
library(nlme)
library(lme4)
library(r2glmm)

data(Orthodont)

# Comparing two linear mixed models
m1 = lmer(distance ~ age*Sex+(1|Subject), Orthodont)
m2 = lmer(distance ~ age*Sex+(1+age|Subject), Orthodont)

m1r2 = r2beta(model=m1,partial=FALSE)
m2r2 = r2beta(model=m2,partial=FALSE)

# Accounting for correlation can make a substantial difference.

r2dt(x=m1r2, y = m2r2, cor = TRUE)
r2dt(x=m1r2, y = m2r2, cor = FALSE)


}
