/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.text;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.text.DocumentTermMatrix;
import org.dmg.pmml.text.TextCorpus;
import org.dmg.pmml.text.TextDictionary;
import org.dmg.pmml.text.TextModelNormalization;
import org.dmg.pmml.text.TextModelSimiliarity;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "textDictionary", "textCorpus", "documentTermMatrix", "textModelNormalization", "textModelSimiliarity", "modelVerification"})
@XmlRootElement(name="TextModel", namespace="http://www.dmg.org/PMML-4_3")
@Deprecated(value=Version.PMML_4_2)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "numberOfTerms", "numberOfDocuments", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "textDictionary", "textCorpus", "documentTermMatrix", "textModelNormalization", "textModelSimiliarity", "modelVerification"})
public class TextModel
extends Model
implements HasExtensions<TextModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTerms", required=true)
    @JsonProperty(value="numberOfTerms")
    private int numberOfTerms;
    @XmlAttribute(name="numberOfDocuments", required=true)
    @JsonProperty(value="numberOfDocuments")
    private int numberOfDocuments;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="TextDictionary", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="TextDictionary")
    private TextDictionary textDictionary;
    @XmlElement(name="TextCorpus", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="TextCorpus")
    private TextCorpus textCorpus;
    @XmlElement(name="DocumentTermMatrix", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="DocumentTermMatrix")
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name="TextModelNormalization", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="TextModelNormalization")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name="TextModelSimiliarity", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="TextModelSimiliarity")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305487L;

    public TextModel() {
    }

    public TextModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="numberOfTerms") int numberOfTerms, @Property(value="numberOfDocuments") int numberOfDocuments, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="textDictionary") TextDictionary textDictionary, @Property(value="textCorpus") TextCorpus textCorpus, @Property(value="documentTermMatrix") DocumentTermMatrix documentTermMatrix) {
        this.miningFunction = miningFunction;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TextModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public TextModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TextModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public int getNumberOfTerms() {
        return this.numberOfTerms;
    }

    public TextModel setNumberOfTerms(@Property(value="numberOfTerms") int numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    public int getNumberOfDocuments() {
        return this.numberOfDocuments;
    }

    public TextModel setNumberOfDocuments(@Property(value="numberOfDocuments") int numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TextModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public TextModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TextModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TextModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TextModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TextModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public TextModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TextModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TextDictionary getTextDictionary() {
        return this.textDictionary;
    }

    public TextModel setTextDictionary(@Property(value="textDictionary") TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    public TextCorpus getTextCorpus() {
        return this.textCorpus;
    }

    public TextModel setTextCorpus(@Property(value="textCorpus") TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    public DocumentTermMatrix getDocumentTermMatrix() {
        return this.documentTermMatrix;
    }

    public TextModel setDocumentTermMatrix(@Property(value="documentTermMatrix") DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    public TextModelNormalization getTextModelNormalization() {
        return this.textModelNormalization;
    }

    public TextModel setTextModelNormalization(@Property(value="textModelNormalization") TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    public TextModelSimiliarity getTextModelSimiliarity() {
        return this.textModelSimiliarity;
    }

    public TextModel setTextModelSimiliarity(@Property(value="textModelSimiliarity") TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TextModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getTextDictionary(), this.getTextCorpus(), this.getDocumentTermMatrix(), this.getTextModelNormalization(), this.getTextModelSimiliarity(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

