/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.primitives.Doubles;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.rexp.DecorationUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.S4Object;

public abstract class GLMNetConverter
extends ModelConverter<RGenericVector> {
    private Double lambdaS = null;

    public GLMNetConverter(RGenericVector glmnet) {
        super(glmnet);
    }

    public abstract Model encodeModel(RDoubleVector var1, RExp var2, int var3, Schema var4);

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        DataField dataField;
        RGenericVector glmnet = (RGenericVector)this.getObject();
        RExp beta = (RExp)glmnet.getElement("beta");
        RStringVector classnames = glmnet.getStringElement("classnames", false);
        if (classnames != null && classnames.size() > 1 && beta instanceof RGenericVector) {
            RGenericVector classBetas = (RGenericVector)beta;
            beta = (S4Object)classBetas.getValue(0);
        }
        RGenericVector dimnames = beta.getGenericAttribute("Dimnames");
        if (classnames != null) {
            dataField = encoder.createDataField(FieldName.create((String)"_target"), OpType.CATEGORICAL, DataType.STRING, classnames.getValues());
            encoder.setLabel(dataField);
        } else {
            dataField = encoder.createDataField(FieldName.create((String)"_target"), OpType.CONTINUOUS, DataType.DOUBLE);
            encoder.setLabel(dataField);
        }
        RStringVector rowNames = dimnames.getStringValue(0);
        for (int i = 0; i < rowNames.size(); ++i) {
            String rowName = rowNames.getValue(i);
            DataField dataField2 = encoder.createDataField(FieldName.create((String)rowName), OpType.CONTINUOUS, DataType.DOUBLE);
            encoder.addFeature((Field<?>)dataField2);
        }
    }

    @Override
    public Model encodeModel(Schema schema) {
        int column;
        RGenericVector glmnet = (RGenericVector)this.getObject();
        RDoubleVector a0 = glmnet.getDoubleElement("a0");
        RExp beta = (RExp)glmnet.getElement("beta");
        RDoubleVector lambda = glmnet.getDoubleElement("lambda");
        Double lambdaS = this.getLambdaS();
        if (lambdaS == null) {
            lambdaS = this.loadLambdaS();
        }
        if ((column = lambda.getValues().indexOf(lambdaS)) < 0) {
            throw new IllegalArgumentException();
        }
        return this.encodeModel(a0, beta, column, schema);
    }

    private Double loadLambdaS() {
        RGenericVector glmnet = (RGenericVector)this.getObject();
        RNumberVector<?> lambdaS = DecorationUtil.getNumericElement(glmnet, "lambda.s");
        return ValueUtil.asDouble((Number)((Number)lambdaS.asScalar()));
    }

    public Double getLambdaS() {
        return this.lambdaS;
    }

    void setLambdaS(Double lambdaS) {
        this.lambdaS = lambdaS;
    }

    public static List<Double> getCoefficients(S4Object beta, int column) {
        RIntegerVector i = beta.getIntegerAttribute("i");
        RIntegerVector p = beta.getIntegerAttribute("p");
        RIntegerVector dim = beta.getIntegerAttribute("Dim");
        RDoubleVector x = beta.getDoubleAttribute("x");
        double[] result = new double[dim.getValue(0).intValue()];
        int begin = p.getValue(column);
        int end = p.getValue(column + 1);
        for (int index = begin; index < end; ++index) {
            result[i.getValue((int)index).intValue()] = x.getValue(index);
        }
        return Doubles.asList((double[])result);
    }
}

