/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.ClassLabels;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ConfusionMatrix", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "classLabels", "matrix"})
@JsonRootName(value="ConfusionMatrix")
@JsonPropertyOrder(value={"extensions", "classLabels", "matrix"})
@Added(value=Version.PMML_4_0)
public class ConfusionMatrix
extends PMMLObject
implements HasExtensions<ConfusionMatrix> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="ClassLabels", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ClassLabels")
    private ClassLabels classLabels;
    @XmlElement(name="Matrix", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Matrix")
    private Matrix matrix;
    private static final long serialVersionUID = 67371270L;

    public ConfusionMatrix() {
    }

    @ValueConstructor
    public ConfusionMatrix(@Property(value="classLabels") ClassLabels classLabels, @Property(value="matrix") Matrix matrix) {
        this.classLabels = classLabels;
        this.matrix = matrix;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ConfusionMatrix addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ClassLabels requireClassLabels() {
        if (this.classLabels == null) {
            throw new MissingElementException(this, PMMLElements.CONFUSIONMATRIX_CLASSLABELS);
        }
        return this.classLabels;
    }

    public ClassLabels getClassLabels() {
        return this.classLabels;
    }

    public ConfusionMatrix setClassLabels(@Property(value="classLabels") ClassLabels classLabels) {
        this.classLabels = classLabels;
        return this;
    }

    public Matrix requireMatrix() {
        if (this.matrix == null) {
            throw new MissingElementException(this, PMMLElements.CONFUSIONMATRIX_MATRIX);
        }
        return this.matrix;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public ConfusionMatrix setMatrix(@Property(value="matrix") Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getClassLabels(), (Visitable)this.getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

