% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R, R/hashmap.R, R/hashset.R
\name{subsetting_hashtables}
\alias{subsetting_hashtables}
\alias{[[.r2r_hashmap}
\alias{[.r2r_hashmap}
\alias{[[<-.r2r_hashmap}
\alias{[<-.r2r_hashmap}
\alias{[[.r2r_hashset}
\alias{[.r2r_hashset}
\alias{[[<-.r2r_hashset}
\alias{[<-.r2r_hashset}
\title{Subsetting \code{hashset}s and \code{hashmap}s}
\usage{
\method{[[}{r2r_hashmap}(x, i)

\method{[}{r2r_hashmap}(x, i)

\method{[[}{r2r_hashmap}(x, i) <- value

\method{[}{r2r_hashmap}(x, i) <- value

\method{[[}{r2r_hashset}(x, i)

\method{[}{r2r_hashset}(x, i)

\method{[[}{r2r_hashset}(x, i) <- value

\method{[}{r2r_hashset}(x, i) <- value
}
\arguments{
\item{x}{an \code{hashset} or \code{hashmap}.}

\item{i}{for \code{`[[`}-subsetting, an arbitrary R object, the key to be
queried or inserted/deleted from the hash tables. For \code{`[`}-subsetting,
a list or an atomic vector whose individual elements correspond to the keys.}

\item{value}{for \code{`[[`}-subsetting: \code{TRUE} or \code{FALSE} if
\code{x} is an \code{hashset}, an arbitrary R object if \code{x} is an
\code{hashmap}. In the case of \code{hashset}s, setting a key's value to
\code{TRUE} and \code{FALSE} is equivalent to inserting and deleting,
respectively, such key from the set. For \code{`[`}-subsetting, \code{value}
must be a list or an atomic vector of the same length of \code{i},
whose individual elements are the values associated to the corresponding
keys in the hash table.}
}
\value{
the replacement forms (\verb{[[<-} and \verb{[<-}) always return \code{value}.
\code{`[[`} returns \code{TRUE} or \code{FALSE} if
\code{x} is an \code{hashset}, an arbitrary R object if \code{x} is an
\code{hashmap} and \code{i} is a valid key; when \code{i} is not a key, the
behaviour for \code{hashmap}s depends on the value of
\code{\link{on_missing_key}(x)}.
The \code{`[`} operator returns a list of the same length of \code{i}, whose
k-th element is given by \code{x[[ i[[k]] ]]} (the remark on missing keys for
hashmaps applies also here).
}
\description{
Subsetting operators \code{`[[`} and \code{`[`} for
\code{hashset}s and \code{hashmap}s provide an equivalent synthax for the
basic read/write operations performed by \code{\link{insert}()},
\code{\link{delete}()} and \code{\link{query}()}.
}
\author{
Valerio Gherardi
}
