% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoa_beta_ratio.r
\name{olkin_beta_ratio}
\alias{olkin_beta_ratio}
\title{olkin_beta_ratio function}
\usage{
olkin_beta_ratio(omat, nv)
}
\arguments{
\item{omat}{3 by 3 matrix having the correlation coefficients between y, x1 and x2, i.e. omat=cor(dat) where dat is N by 3 matrix having variables in the order of cbind (y,x1,x2)}

\item{nv}{sampel size}
}
\value{
This function will generate the variance of the proportion, i.e. beta1_2/R^2.The outputs are listed as follows.
\item{ratio_var}{Variance of ratio}
}
\description{
This function derives variance of beta1^2 / R^2
where beta1 and 2 are regression coefficients from a multiple regression model,
i.e. y = x1 * beta1 + x2 * beta2 + e, where y, x1 and x2 are column-standardised
(see Olkin and Finn 1995).
}
\examples{
#To get information (variance-covariance) matrix of beta1 and beta2 where 
#beta1 and 2 are regression coefficients from a multiple regression model.
dat=dat2
omat=cor(dat)[1:3,1:3]
#omat
#1.0000000 0.1497007 0.136431
#0.1497007 1.0000000 0.622790
#0.1364310 0.6227900 1.000000

nv=length(dat$V1)
output=olkin_beta_ratio(omat,nv)
output 

#r2redux output

#output$ratio_var (Variance of ratio)
#0.08042288
}
\references{
Olkin, I. and Finn, J.D. Correlations redux. Psychological Bulletin, 1995. 118(1): p. 155.
}
\keyword{context}
\keyword{correlation}
\keyword{in}
\keyword{information}
\keyword{matrix}
\keyword{of}
\keyword{the}
