% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_attributes.R
\name{rtf_colheader}
\alias{rtf_colheader}
\title{Add column header to the table}
\usage{
rtf_colheader(
  tbl,
  colheader = NULL,
  border_left = "single",
  border_right = "single",
  border_top = NULL,
  border_bottom = "",
  border_color_left = NULL,
  border_color_right = NULL,
  border_color_top = NULL,
  border_color_bottom = NULL,
  border_width = 15,
  cell_justification = "c",
  col_rel_width = NULL,
  page_width = 8.5,
  col_total_width = page_width/1.4,
  cell_height = 0.15,
  text_justification = "c",
  text_font = 1,
  text_format = NULL,
  text_color = NULL,
  text_background_color = NULL,
  text_font_size = 9,
  text_space_before = 15,
  text_space_after = 15,
  first_row = FALSE
)
}
\arguments{
\item{tbl}{A data frame}

\item{colheader}{A string that uses " | " to separate column names.}

\item{border_left}{left border type}

\item{border_right}{right border type}

\item{border_top}{top border type}

\item{border_bottom}{bottom border type}

\item{border_color_left}{left border color}

\item{border_color_right}{right border color}

\item{border_color_top}{top border color}

\item{border_color_bottom}{bottom border color}

\item{border_width}{border width in twips}

\item{cell_justification}{justification for cell}

\item{col_rel_width}{column relative width in a vector eg. c(2,1,1) refers to 2:1;1}

\item{page_width}{page width in inches}

\item{col_total_width}{column total width for the table}

\item{cell_height}{height for cell in twips}

\item{text_justification}{justification for text}

\item{text_font}{text font type}

\item{text_format}{text format}

\item{text_color}{text color}

\item{text_background_color}{text background color}

\item{text_font_size}{text font size}

\item{text_space_before}{line space before text}

\item{text_space_after}{line space after text}

\item{first_row}{boolean value to indicate whether column header is the first row of the table}
}
\value{
the same data frame \code{tbl} with additional attributes for table column header
}
\description{
Add column header to the table
}
\examples{
library(dplyr) # required to run examples
data(tbl_1)
tbl_1 \%>\%
  rtf_colheader(colheader = "Treatment | N | Mean (SD) | N | Mean (SD) | N |
                  Mean (SD) | LS Mean (95\% CI)\\\\dagger") \%>\%
  attr("rtf_colheader")

}
