% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal_test.R
\name{kruskal_test}
\alias{kruskal_test}
\alias{to_SPSS.kruskal_test_SPSS}
\alias{print.kruskal_test_SPSS}
\alias{kruskalTest}
\title{Kruskal-Wallis Test}
\usage{
kruskal_test(data, variable, group)

\method{to_SPSS}{kruskal_test_SPSS}(
  object,
  statistics = c("test", "ranks"),
  version = r2spss_options$get("version"),
  digits = NULL,
  ...
)

\method{print}{kruskal_test_SPSS}(
  x,
  statistics = c("ranks", "test"),
  version = r2spss_options$get("version"),
  digits = 2:3,
  ...
)

kruskalTest(data, variable, group)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variable}{a character string specifying the numeric variable of
interest.}

\item{group}{a character string specifying a grouping variable.}

\item{object, x}{an object of class \code{"kruskal_test_SPSS"} as returned
by function \code{kruskal_test}.}

\item{statistics}{a character string or vector specifying which SPSS tables
to produce.  Available options are \code{"ranks"} for a summary of the ranks
and \code{"test"} for test results.  For the \code{to_SPSS} method, only one
option is allowed (the default is the table of test results), but the
\code{print} method allows several options (the default is to print all
tables).}

\item{version}{a character string specifying whether the table should
mimic the content and look of recent SPSS versions (\code{"modern"}) or
older versions (<24; \code{"legacy"}).  The main differences in terms of
content are the label of the test statistic and that small p-values are
displayed differently.}

\item{digits}{for the \code{to_SPSS} method, an integer giving the number
of digits after the comma to be printed in the SPSS table.  For the
\code{print} method, this should be an integer vector of length 2, with the
first element corresponding to the number of digits in table with the
summary of the ranks, and the second element corresponding to the number of
digits in the table for the test.}

\item{\dots}{additional arguments to be passed down to
\code{\link{format_SPSS}}.}
}
\value{
An object of class \code{"kruskal_test_SPSS"} with the following components:
\describe{
  \item{\code{statistics}}{a data frame containing information on the
  per-group mean ranks.}
  \item{\code{test}}{a list containing the results of the Kruskal-Wallis
  test.}
  \item{\code{variable}}{a character string containing the name of the
  numeric variable of interest.}
  \item{\code{group}}{a character string containing the name of the
  grouping variable.}
}

The \code{to_SPSS} method returns an object of class \code{"SPSS_table"}
which contains all relevant information in the required format to produce
the LaTeX table.  See \code{\link{to_latex}} for possible components and
how to further customize the LaTeX table based on the returned object.

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output.
}
\description{
Perform a Kruskal-Wallis test on variables of a data set.  The output is
printed as a LaTeX table that mimics the look of SPSS output.
}
\details{
The \code{print} method first calls the \code{to_SPSS} method followed
by \code{\link{to_latex}}.  Further customization can be done by calling
those two functions separately, and modifying the object returned by
\code{to_SPSS}.
}
\note{
LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
# load data
data("Eredivisie")

# test whether market values differ by playing position
kruskal_test(Eredivisie, "MarketValue", group = "Position")

}
\author{
Andreas Alfons
}
\keyword{htest}
