/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.Grid;
import com.conveyal.r5.analyst.IsochroneFeature;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.WebMercatorExtents;
import com.conveyal.r5.analyst.WebMercatorGridPointSet;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5Process;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;

public class IsochroneBuilder
extends R5Process {
    private int[] cutoffs;
    private Grid gridPointSet = null;

    public IsochroneBuilder(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    public void setResolution(int resolution) {
        this.gridPointSet = new Grid(resolution, this.transportNetwork.getEnvelope());
    }

    public void setCutoffs(int[] cutoffs) {
        this.cutoffs = cutoffs;
    }

    @Override
    protected LinkedHashMap<String, ArrayList<Object>> runProcess(int index) throws ParseException {
        int[] times;
        RegionalTask request = this.buildRequest(index);
        List<IsochroneFeature> isochroneFeatures = this.buildIsochroneFeatures(request, times = this.computeTravelTimes(request));
        RDataFrame isochronesTable = this.buildIsochronesTable(this.fromIds[index], isochroneFeatures);
        if (isochronesTable.nRow() > 0) {
            return isochronesTable.getDataFrame();
        }
        return null;
    }

    private int[] computeTravelTimes(RegionalTask request) {
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        int[] times = travelTimeResults.travelTimes.getValues()[0];
        for (int i = 0; i < times.length; ++i) {
            times[i] = times[i] <= this.maxTripDuration ? times[i] * 60 : Integer.MAX_VALUE;
        }
        return times;
    }

    private List<IsochroneFeature> buildIsochroneFeatures(RegionalTask request, int[] times) {
        WebMercatorExtents extents = WebMercatorExtents.forPointsets((PointSet[])request.destinationPointSets);
        WebMercatorGridPointSet isoGrid = new WebMercatorGridPointSet(extents);
        LinkedList<IsochroneFeature> isochroneFeatures = new LinkedList<IsochroneFeature>();
        for (int cutoff : this.cutoffs) {
            isochroneFeatures.add(new IsochroneFeature(cutoff * 60, isoGrid, times));
        }
        return isochroneFeatures;
    }

    private RDataFrame buildIsochronesTable(String fromId, List<IsochroneFeature> isochroneFeatures) {
        RDataFrame isochronesTable = new RDataFrame();
        isochronesTable.addStringColumn("from_id", fromId);
        isochronesTable.addIntegerColumn("cutoff", 0);
        isochronesTable.addStringColumn("geometry", "");
        for (IsochroneFeature isochroneFeature : isochroneFeatures) {
            isochronesTable.append();
            isochronesTable.set("cutoff", isochroneFeature.cutoffSec / 60);
            isochronesTable.set("geometry", isochroneFeature.geometry.toString());
        }
        return isochronesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = this.gridPointSet;
        request.percentiles = new int[1];
        request.percentiles[0] = 50;
        return request;
    }
}

