% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDATVOLABMR.R
\name{BDATVOLABMR}
\alias{BDATVOLABMR}
\title{Calculate wood volume over bark of a tree between height A and B}
\usage{
BDATVOLABMR(BDATArtNr, D1, H1 = 1.3, D2 = 0, H2 = 0, H, A, B, SekLng = 2)
}
\arguments{
\item{BDATArtNr}{numeric vector of species code; see
\code{\link{getSpeciesCode}}.}

\item{D1}{first measured diameter of tree [cm], e.g. diameter in breast
height.}

\item{H1}{measurement height of \code{D1} [m]}

\item{D2}{second measured diameter of tree, see \code{\link{buildTree}} for
details on how to specify different taper forms}

\item{H2}{measurement height of D2, see \code{\link{buildTree}} for details
on how to specify different taper forms}

\item{H}{total tree height [m]}

\item{A}{lower height of section for which volume is required [m]}

\item{B}{upper height of section for which volume is required [m]}

\item{SekLng}{length of section over which the integral of taper form should
be applied, defaults to 2.0m}
}
\value{
vector of same length as input variables transformed into a
data.frame, returning the required wood volume in cubic meter.
}
\description{
BDAT-Function to get wood volume over bark of one or many trees
of a section between height A and height B
}
\details{
wood volume is calculated using BDAT Fortran routines.
}
\examples{
## simple call of function, with all parameters
BDATVOLABMR(1, 30, 1.3, 0, 0, 25, .25, 5.25, 2.0)
BDATArtNr <- 1
D1 <- 30
H1 <- 1.3
D2 <- 0
H2 <- 0
H <- 25
A <- 1
B <- 10

## same given variables
BDATVOLABMR(BDATArtNr = BDATArtNr, D1 = D1, H1 = H1, D2 = D2, H2 = H2, H = H, A = A, B = B)

## calling with a subset of tree characteristics
## german species names, abbreviated
BDATVOLABMR(getSpeciesCode(c("Fi", "Bu")), 30, 0, 0, 0, H = 25, A = 0, B = 25)
## english abbreviated
BDATVOLABMR(getSpeciesCode(c("NS", "BE")), 30, 0, 0, 0, H = 25, A = 0, B = 25)
}
\seealso{
\code{\link{BDATVOLABOR}} for BDAT routine calculating volume under
bark, \code{\link{getVolume}} for a function with a convenient english name,
more options and a bark switch.
}
