\name{cmaSamplePopulation}
\alias{cmaSamplePopulation}
\title{Sample a population from the current CMA-ES distribution.}
\usage{
  cmaSamplePopulation(cma)
}
\arguments{
  \item{cma}{CMA-ES Java object, already initialized with
  \code{\link{cmaInit}}}
}
\value{
  \code{popR}, a (\code{dimension x popSize}) matrix with
  \code{popR[,1]} being the first individuum in the
  population. \cr \code{dimension =
  \link{cmaGetDimension}(cma)} \cr \code{popSize =
  \link{cmaGetPopulationSize}(cma)} \cr
}
\description{
  The population size is given by
  \code{\link{cmaGetPopulationSize}(cma)}. It can be either
  set manually with
  \code{\link{cmaSetPopulationSize}(cma,p)}, prior to
  \code{\link{cmaInit}(cma)}, or CMA-ES will use the
  default population size\cr \code{popSize = 4 +
  3*log(dimension)}.
}
\examples{
cma <- cmaNew();
   cmaInit(cma,dimension=2,initialX=1.5);
   popR <- cmaSamplePopulation(cma);
}
\author{
  Wolfgang Konen, FHK, 2013
}
\seealso{
  \code{\link{cmaUpdateDistribution}}, \code{\link{cmaNew}}
}

