% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extrDAC.R
\name{extrDAC}
\alias{extrDAC}
\title{The Dinucleotide-based Auto Covariance Descriptor}
\usage{
extrDAC(x, index = c("Twist", "Tilt"), nlag = 2, normaliztion = FALSE,
  customprops = NULL, allprop = FALSE)
}
\arguments{
\item{x}{the input data, which should be a list or file type.}

\item{index}{the physicochemical indices, it should be a list and there are 38
             different physicochemical indices (Table 1), which the users can choose.}

\item{nlag}{an integer larger than or equal to 0 and less than or equal to L-2 (L means the length
            of the shortest DNA sequence in the dataset). It represents the distance between two dinucleotides.}

\item{normaliztion}{with this option, the final feature vector will be normalized based
                 on the total occurrences of all kmers. Therefore, the elements in the feature vectors
                 represent the frequencies of kmers. The default value of this parameter is False.}

\item{customprops}{the users can use their own indices to generate the feature vector. It should be a dict,
                   the key is dinucleotide (string), and its corresponding value is a list type.}

\item{allprop}{all the 38 physicochemical indices will be
               employed to generate the feature vector. Its default value is False.}
}
\value{
A vector
}
\description{
The Dinucleotide-based Auto Covariance Descriptor
}
\details{
This function calculates the dinucleotide-based auto covariance descriptor
}
\note{
if the user defined physicochemical indices have not been normalized, it should be normalized.
}
\examples{
x = 'GACTGAACTGCACTTTGGTTTCATATTATTTGCTC'
extrDAC(x)
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\references{
Dong Q, Zhou S, Guan J. A new taxonomy-based protein fold recognition approach based on
autocross-covariance transformation. \emph{Bioinformatics}, 2009, 25(20): 2655-2662.
}
\seealso{
See \code{\link{extrDCC}} and \code{\link{extrDACC}}
}
\keyword{DAC}
\keyword{extract}

