% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_functions.R
\name{make_surrogate_data}
\alias{make_surrogate_data}
\title{Generate surrogate data for permutation/randomization tests}
\usage{
make_surrogate_data(ts, method = c("random_shuffle", "ebisuzaki", "seasonal"),
  num_surr = 100, T_period = 1)
}
\arguments{
\item{ts}{the original time series}

\item{method}{which algorithm to use to generate surrogate data}

\item{num_surr}{the number of null surrogates to generate}

\item{T_period}{the period of seasonality for seasonal surrogates (ignored for other methods)}
}
\value{
A matrix where each column is a separate surrogate with the same length as \code{ts}.
}
\description{
\code{make_surrogate_data} generates surrogate data under several different 
null models.
}
\details{
Method "random_shuffle" creates surrogates by randomly permuting the values 
of the original time series.

Method "Ebisuzaki" creates surrogates by randomizing the phases of a Fourier 
transform, preserving the power spectra of the null surrogates.

Method "seasonal" creates surrogates by computing a mean seasonal trend of 
the specified period and shuffling the residuals.

See \code{test_nonlinearity} for context.
}
\examples{
data("two_species_model")
ts <- two_species_model$x[1:200]
make_surrogate_data(ts, method = "ebisuzaki")
}

