% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{extract_keywords}
\alias{extract_keywords}
\title{Function to extract rows from a lookup table based on keywords}
\usage{
extract_keywords(lookup, keywords, keyword_field = "desc")
}
\arguments{
\item{lookup}{a dataframe containing a lookup table}

\item{keywords}{character vector containing the keyword terms to search for}

\item{keyword_field}{character identifying the field in the lookup table to be searched 
for keywords}
}
\value{
a data frame subsetted by keyword
}
\description{
This function can be used to build draft clinical code lists based on a clinical or 
product lookup table and a set of keywords.
}
\details{
See www.clinicalcodes.org for clinical code lists that have been used in previous studies

All keywords are collapsed together in an OR statement
}
\examples{
\dontrun{
keywords <- c('oral ulceration', 'mouth ulceration', 'aphthous ulceration', 
'oral aphthous ulceration','oral ulcer[s]?', 'mouth ulcer[s]?', 'aphthous ulcer[s]?', 
'aphthous stomatitis', "stomatitis", "aphthae", 'oral aphthous stomatitis', 
'oral aphthous ulcers', 'recurrent oral ulcers', 'recurrent mouth ulcers', 
'recurrent oral aphthous ulcers', 'recurrent aphthous ulcers', 'recurrent aphthous stomatitis', 
'recurrent oral aphthous stomatitis')
a <- extract_keywords(medical, keywords)
}
}

