% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{prev_totals}
\alias{prev_totals}
\title{Calculates the prevalence totals for the output of a data frame of events/patients etc.}
\usage{
prev_totals(dat, included_totals = c("year", .ehr$practice_id),
  time_var = "year", person_years = 100)
}
\arguments{
\item{dat}{a dataframe}

\item{included_totals}{character vector describing which aggregates should be included e.g. c("year", "practid")}

\item{time_var}{name of the variable determining timepoints}

\item{person_years}{numeric multiplier for presentation of prevalence and incidence numbers}
}
\value{
list of aggregates and/or the original data
}
\description{
e.g. Run on the output of a call to prev_terms
}
\details{
Outputs totals by aggregated by a time variable and other variables
Updated to use dplyr to do the aggregation - Now 40x faster!
}

