% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ehr_simulation.R
\name{surv_sims}
\alias{surv_sims}
\title{Function to simulate survival data.}
\usage{
surv_sims(cov_mat, beta, cens_type = c("typeI", "noninformative"),
  baseline_hazard, cens_hazard = 0.04, cens_prob = 0, scale = 1,
  weibull_shape = 1)
}
\arguments{
\item{cov_mat}{n x p matrix of cov_matiates}

\item{beta}{p-vector of regression coefficients}

\item{cens_type}{typeI censoring or non-informative based on exponential distribution}

\item{baseline_hazard}{for modelling death dates}

\item{cens_hazard}{log(hazard) for non-informative censoring}

\item{cens_prob}{expected censoring fraction (0 <= cens_prob < 1). Used for typeI censoring}

\item{scale}{value to scale up the time variable by}

\item{weibull_shape}{shape parameter for the weibull distribution. 1 is the same as an exponential}
}
\value{
Censored exponential survival times and censoring
}
\description{
Model: proportional hazards,
h(t; cov_mat, beta) = exp(cov_mat %*% beta)) / scale
indicators for Type I censoring (common censoring time 'tc').
}
\details{
Weibull_shape is the k (shape) parameter from a weibull distribution 
\itemize{
   \item A value of k < 1 indicates that the mortality rate decreases over time. 
 This happens if there is significant infant mortality
   \item A value of k = 1 indicates that the mortality rate is constant over time. 
   This might suggest random external events are causing mortality. This is the same as an 
   exponential distribution
   \item A value of k > 1 indicates that the mortality rate increases with time. 
   This happens if there is an aging process.
}
}

