% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_02_risksets_2.r
\name{f_risksets}
\alias{f_risksets}
\title{Rsiksets}
\usage{
f_risksets(formula, data, lag, id_name, time_name)
}
\arguments{
\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{event format data set than is ouput of the functions f_to_event...}

\item{lag}{latency period}

\item{id_name}{name of variable containing the names of subjects}

\item{time_name}{name of the time variable}
}
\value{
a named list with integer vectors containing the number of rows that are in each the riskset (relevant person-time)
}
\description{
Computes the riskset for each case with the relevant variables in the formula and the stratification vars specified in strata() part of the formula.
The riskset of a case inculde the subjects that are in the cohort when the case ocurs: so a subject S belongs to the riskset R of the case that have a 'fail' at time ft,
if S_entry_time < ft <= S_exit_time.
}
\examples{
\donttest{ f_riskset(formula,data,lag=2,id_name='patientids',time_name='time')}
}
