% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel2B.R
\name{clipLevel2BGeometry}
\alias{clipLevel2BGeometry}
\title{Clip GEDI Level2B data by geometry}
\usage{
clipLevel2BGeometry(level2b, polygon_spdf, output = "",
  split_by = NULL)
}
\arguments{
\item{level2b}{A GEDI Level2B object (output of \code{\link[rGEDI:readLevel2B]{readLevel2B}} function).
An S4 object of class "gedi.level2b".}

\item{polygon_spdf}{Polygon. An object of class \code{\link[sp]{SpatialPolygonsDataFrame-class}},
which can be loaded as an ESRI shapefile using \code{\link[raster:shapefile]{raster::shapefile()}} function in the \emph{raster} package.}

\item{output}{optional character path where to save the new h5file. Default "" (temporary file).}

\item{split_by}{Polygon id. If defined, GEDI data will be clipped by each polygon using the attribute specified by \code{split_by} from the attribute table.}
}
\value{
Returns a list of S4 objects of class "gedi.level2b" containing clipped GEDI Level2B data.
}
\description{
This function extracts GEDI Level1B data within a given geometry
}
\examples{
\donttest{
outdir = tempdir()

# Specifying the path to GEDI level2B data (zip file)
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = dirname(level2B_fp_zip))

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Specifying the path to shapefile
polygon_filepath <- system.file("extdata", "stands_cerrado.shp", package="rGEDI")

# Reading shapefile as SpatialPolygonsDataFrame object
library(raster)
polygon_spdf<-shapefile(polygon_filepath)

# Specifying output file and path
output<-file.path(outdir,"GEDI02_B_2019108080338_O01964_T05337_02_001_01_clip")

# Clipping GEDI data by extent boundary box
level2b_clip <- clipLevel2BGeometry(level2b, polygon_spdf = polygon_spdf,
                                   output=output,
                                   split_by="id")

close(level2b)
lapply(level2b_clip, close)
}
}
\seealso{
https://lpdaac.usgs.gov/products/gedi01_bv001/
}
