% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{m_value}
\alias{m_value}
\title{Calculate M-value}
\usage{
m_value(x, unit = "mg", index = 120, method = "manuscript")
}
\arguments{
\item{x}{vector of glucose readings}

\item{unit}{"mg" if the units are mg/dL or "mmol" if the units are mmol/L. Null value is "mg".}

\item{index}{value to be considered a 'standard' blood glucose value, in mg/dL. Null value is 120.}

\item{method}{"manuscript", "corrected", or "easy". Null value is "manuscript".}
}
\value{
The numeric M-value for a given dataset of glucose measurements.
}
\description{
Calculate M-value
}
\examples{
m_value(x=c(rep(100, 10), rep(120, 10), 105, 85), unit='mg', index=120, method='manuscript')
}
