% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_ref.R
\name{bw_ref}
\alias{bw_ref}
\title{Normal Reference Distribution.}
\usage{
bw_ref(x)
}
\arguments{
\item{x}{2d matrix of data values.}
}
\value{
A numeric vector of estimated x and y bandwidths. Must subset your data if you wish to obtain group specific bandwidths.
}
\description{
A simple wrapper for the MASS::bandwidth.nrd function. Divides values by 4 to match the scale of ks methods
}
\examples{
data("rodents")
# Subset the data for a single species
spec1<- rodents[rodents$Species == "Species1", ]
# Calculate the bandwidth
bw_hucv(as.matrix(spec1[, c("Ave_C", "Ave_N")]))
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
