% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.depth.R
\name{msc.depth}
\alias{msc.depth}
\title{Check the read depth of assembled minicircles}
\usage{
msc.depth(depthstats, groups, HCN = NULL)
}
\arguments{
\item{depthstats}{a character vector containing the file names of the depth statistics (output of KOMICS), e.g. sampleA.depthstats.txt, sampleB.depthstats.txt,... .}

\item{groups}{a vector specifying to which groups (e.g. species) the samples belong to.}

\item{HCN}{a numeric vector containing haploid copy numbers of the corresponding samples (optional, by default set to null).}
}
\value{
\item{all}{a table merging depth statistics of all samples. Depth statistics include the average, median, minimum and maximum per site read depth. }
\item{plots}{a plot per sample visualizing the median read depth distribution.}
\item{medianRD}{one graph summarizing the median read depth distribution of all samples.}
\item{CN}{one graph summarizing the copy number (if HCN is not null) of all samples.}
}
\description{
The depth statistics, generated with KOMICS, include average, median, minimum and maximum per site read depth of every minicircle contig that has been assembled.
The msc.depth function allows you to summarize those statistics and to estimate minicircle copy numbers by standardizing median read depths per minicircle contig to the median genome-wide read depths.
}
\examples{
require(ggpubr)
data(exData)

### run function
\donttest{
depth <- msc.depth(depthstats = system.file("extdata", 
                  exData$depthstats, package = "rKOMICS"), groups = exData$species,
                  HCN = exData$medGWD/2)

### visualize results 
hist(depth$all[,"MEDIAN.DEPTH"], breaks=100, 
    main="Global median depth distribution",xlab = (''))

### alter plot 
annotate_figure(depth$plots$CUM29A1, fig.lab = "CUM29A1", 
               fig.lab.pos = "bottom.right", fig.lab.face = 'italic')
}
}
