% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.length.R
\name{msc.length}
\alias{msc.length}
\title{Length of minicircles}
\usage{
msc.length(file, samples, groups)
}
\arguments{
\item{file}{the name of the fasta file containing all minicircle sequences, e.g. all.minicircles.circ.fasta.}

\item{samples}{a character vector containing the sample names.}

\item{groups}{a vector, of equal length as samples, specifying to which group (e.g. subspecies) the samples belong to.}
}
\value{
\item{length}{a numerical vector containing the length of minicircle sequences.}
\item{plot}{a histogram visualizing the length frequency of minicircle sequences.}
}
\description{
The msc.length function allows you to check the length of minicircle sequences based on one fasta file.
}
\examples{
require(ggplot2)
require(ggpubr)

### run function
bf <- msc.length(file = system.file("extdata", "all.minicircles.fasta", package="rKOMICS"),
                 samples = exData$samples, groups = exData$subspecies)
af <- msc.length(file = system.file("extdata", "all.minicircles.circ.fasta", package="rKOMICS"),
                 samples = exData$samples, groups = exData$subspecies)

length(which(bf$length<800)) 
length(which(bf$length>1400)) 

### visualize results
hist(af$length, breaks=50)

### alter plot
ggarrange(bf$plot + labs(caption = "Before filtering"), 
          af$plot + labs(caption = "After filtering"), nrow=2)


}
