% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtr.layer.segments.R
\name{wtr.layer}
\alias{wtr.layer}
\title{Exploration of lake water column layers}
\usage{
wtr.layer(data, depth, measure, thres = 0.1, z0 = 2.5, zmax = 150,
  nseg = "unconstrained")
}
\arguments{
\item{data}{data supplied as a bare (unquoted) value}

\item{depth}{depth in metres; should be an increasing vector; supplied as a
bare (unquoted) value}

\item{measure}{parameter measured in the water column profile; supplied as a
bare (unquoted) value}

\item{thres}{error norm; defaults to 0.1}

\item{z0}{initial depth in metres. Defaults to 2.5m}

\item{zmax}{maximum depth in metres: defaults to 150m}

\item{nseg}{optional parameter to define the number of segments a priori;
defaults to an unconstrained approach whereby the algorithm determines
segmentations by minimzing the error norm over each segment}
}
\value{
a dataframes with a list column. This includes: nseg (number of
segments), mld (mix layer depth), cline (the midpoint of the segment
connecting inflection points that has the maximum slope; thermocline for
temperature measures) and segments calculated by the sm algorithm.
}
\description{
Extract water column parameters of a given parameter from a profile using
the split-and-merge algorithm.  The cline is defined as the midpoint of the
layer of water where the physical property change in the greatest over a
small difference. The exact cline depends on the specification of measure.
For example if temperature is specified, then we can expect cline to output
the thermocline.
}
\examples{

data("latesummer")
df1 <- wtr.layer(depth=latesummer$depth, measure = latesummer$temper)
df1$mld
df1$segments

wtr.layer(data = latesummer, depth=depth, measure = temper, nseg=4)


}
\references{
Thomson, R. and I. Fine. 2003. Estimating Mixed Layer Depth from
Oceanic Profile Data. Journal of Atmospheric and Oceanic Technology. 20(2),
319-329.
}
