% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_generics.R, R/ODESolver.R,
%   R/AbstractODESolver.R, R/DormandPrince45.R
\docType{methods}
\name{getStepSize}
\alias{getStepSize}
\alias{getStepSize,ODESolver-method}
\alias{getStepSize,AbstractODESolver-method}
\alias{getStepSize,DormandPrince45-method}
\title{Get the step size}
\usage{
getStepSize(object, ...)

\S4method{getStepSize}{ODESolver}(object, ...)

\S4method{getStepSize}{AbstractODESolver}(object, ...)

\S4method{getStepSize}{DormandPrince45}(object, ...)
}
\arguments{
\item{object}{a class object}

\item{...}{additional parameters}
}
\description{
Get the step size
}
\examples{
# +++++++++++++++++++++++++++++++++++++++++ Example:      ComparisonRK45ODEApp.R
# Updates the ODE state instead of using the internal state in the ODE solver
# Also plots the solver solution versus the analytical solution at a
# tolerance of 1e-6
# ODE Solver:   Runge-Kutta 45
# Class:        RK45

importFromExamples("ODETest.R")

ComparisonRK45ODEApp <- function(verbose = FALSE) {
    ode <- new("ODETest")                         # new ODE instance
    ode_solver <- RK45(ode)                       # select ODE solver
    ode_solver <- setStepSize(ode_solver, 1)      # set the step
    ode_solver <- setTolerance(ode_solver, 1e-6)  # set the tolerance
    time <-  0
    rowVector <- vector("list")                   # row vector
    i <- 1    # counter
    while (time < 50) {
        # add solution objects to a row vector
        rowVector[[i]] <- list(t = ode_solver@ode@state[2],
                               ODE = getState(ode_solver@ode)[1],
                               s2  = getState(ode_solver@ode)[2],
                               exact = getExactSolution(ode_solver@ode, time),
                               rate.counts = getRateCounts(ode),
                               time = time )
        ode_solver <- step(ode_solver)            # advance solver one step
        stepSize <-  getStepSize(ode_solver)      # get the current step size
        time <- time + stepSize
        ode <- ode_solver@ode                     # get updated ODE object
        state <- getState(ode)                    # get the `state` vector
        i <- i + 1                                # add a row vector
    }
    DT <- data.table::rbindlist(rowVector)        # create data table
    return(DT)
}

solution <- ComparisonRK45ODEApp()
plot(solution)
library(ggplot2)
library(dplyr)
library(tidyr)
solution.multi <- solution \%>\%
    select(t, ODE, exact)
plot(solution.multi)
solution.2x1 <- solution.multi \%>\%
    gather(key, value, -t)
g <- ggplot(solution.2x1, mapping = aes(x = t, y = value, color = key))
g <-  g + geom_line(size = 1) + labs(title = "ODE vs Exact solution",
                                     subtitle = "tolerance = 1E-6")
print(g)




}
