% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPACI.R
\name{analyzeFolder}
\alias{analyzeFolder}
\title{Analysis several corneal topography files in a common folder.}
\usage{
analyzeFolder(
  path,
  fileExtension = "txt",
  individualPlots = FALSE,
  summaryPlot = FALSE
)
}
\arguments{
\item{path}{The path of a folder which contains corneal topography files, as exported by Placido disks corneal topographers.}

\item{fileExtension}{The file extension of the corneal topography files in the folder ('.txt' by default).}

\item{individualPlots}{An optional logical parameter indicating whether the plot for each file should be displayed or not.}

\item{summaryPlot}{An optional logical parameter indicating whether a summary plot should be displayed or not.}
}
\description{
Analyze all corneal topography files in a specific folder. It is equivalent to use \link[rPACI]{analyzeFile} for each file in the folder.
It assumes all files with the given extension ('.txt' by defualt) are corneal topography files.
}
\examples{
analyzeFolder(system.file("extdata",package="rPACI"))
}
