% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch.R
\name{pitch.plot}
\alias{pitch.plot}
\title{pitch.plot}
\usage{
pitch.plot(
  pitch,
  scaleIntensity = TRUE,
  showStrength = FALSE,
  group = "",
  pt = NULL
)
}
\arguments{
\item{pitch}{Pitch object}

\item{scaleIntensity}{Point size scaled according to relative intensity}

\item{showStrength}{Show strength annotation}

\item{group}{[optional] character string, name of group for dygraphs synchronization}

\item{pt}{[optional] PitchTier object}
}
\description{
Plots interactive Pitch object using \code{dygraphs} package.
}
\examples{
\dontrun{
pitch <- pitch.sample()
pitch.plot(pitch, scaleIntensity = TRUE, showStrength = TRUE)

pitch.plot(pitch, scaleIntensity = TRUE, showStrength = TRUE, pt = pt.sample())
}
}
\seealso{
\code{\link{pitch.read}}, \code{\link{pitch.sample}}, \code{\link{pitch.toArray}}, \code{\link{tg.plot}}, \code{\link{pt.plot}}, \code{\link{formant.plot}}
}
