% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snd.R
\name{snd.cut0}
\alias{snd.cut0}
\title{snd.cut0}
\usage{
snd.cut0(snd, Start = -Inf, End = Inf, units = "seconds")
}
\arguments{
\item{snd}{Sound object (list with \code{$sig} and \code{$fs} members at least)}

\item{Start}{beginning sample/time of interval to be cut (default \code{-Inf} = cut from the beginning of the Sound)}

\item{End}{final sample/time of interval to be cut (default \code{Inf} = cut to the end of the Sound)}

\item{units}{Units of \code{Start} and \code{End} arguments: \code{"samples"} (starting from 1, i.e., 1 == index of the 1st sample) or \code{"seconds"} (starting from 0)}
}
\value{
Sound object
}
\description{
Cut the specified interval from the Sound object and and shift time so that the new \code{snd$t[1]} = 0
}
\examples{
snd <- snd.sample()
snd2 <-   snd.cut(snd,  Start = 0.3)
snd2_0 <- snd.cut0(snd, Start = 0.3)
snd3 <-   snd.cut(snd,  Start = 0.2, End = 0.3)
snd3_0 <- snd.cut0(snd, Start = 0.2, End = 0.3)
snd4 <-   snd.cut(snd,  End = 0.1)
snd4_0 <- snd.cut0(snd, End = 0.1)
snd5 <-   snd.cut(snd,  Start = -0.1, End = 0.1)
snd5_0 <- snd.cut0(snd, Start = -0.1, End = 0.1)
snd6 <-   snd.cut(snd,  End = 1000, units = "samples")
snd6_0 <- snd.cut0(snd, End = 1000, units = "samples")
\dontrun{
snd.plot(snd)
snd.plot(snd2)
snd.plot(snd2_0)
snd.plot(snd3)
snd.plot(snd3_0)
snd.plot(snd4)
snd.plot(snd4_0)
snd.plot(snd5)
snd.plot(snd5_0)
snd.plot(snd6)
snd.plot(snd6_0)
}
}
\seealso{
\code{\link{snd.cut}}, \code{\link{tg.cut}}, \code{\link{tg.cut0}}, \code{\link{snd.read}}, \code{\link{snd.plot}}
}
