% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show-pref.r
\docType{methods}
\name{show.pref}
\alias{show.pref}
\alias{as.character,preference-method}
\alias{as.character,basepref-method}
\alias{as.character,emptypref-method}
\alias{as.character,complexpref-method}
\alias{as.character,reversepref-method}
\alias{pref.str}
\alias{partial.eval.pref}
\title{Partial Evaluation and String Output of Preferences}
\usage{
show.pref(p, df = NULL)

\S4method{as.character}{preference}(x, ...)

pref.str(p, df = NULL)

partial.eval.pref(p, df = NULL)
}
\arguments{
\item{p, x}{The preference to be shown or partially evaluated.}

\item{df}{(optional) A data frame on which the preference operates. Used for partial evaluation.}

\item{...}{Optional arguments passed to \code{as.character}.}
}
\description{
Functions to substitute variables and functions in preferences 
which can be calculated before the preference is evaluated on a data frame
and character output of preferences.
}
\details{
The function \code{pref.str} (or \code{as.character(p)} for a preference \code{p}) returns the preference string 
while \code{show.pref} outputs it directly to the console, preceded by \code{'[Preference]'}.
If \code{df} is specified, then a partial evaluation of the preference is done before converting it to a string. 


The function \code{partial.eval.pref} (with given data frame \code{df}) partially evaluates the internal preference expression and 
returns again a preference object. All expressions in \code{p} are evaluated in the environment
where \code{p} was defined, except the the column names in \code{df} (which are potential attributes in \code{p}) 
and except the special variable \code{df__}, which accesses the entire data set (see \code{\link{psel}}).
The content of the data frame \code{df} does not matter; only \code{names(df)} is used to get the "free variables" in \code{p}.

If \code{p} has already an associated data frame (see \code{\link{assoc.df}}), 
then a partial evaluation was already done when the data frame was associated.
In this case, the \code{df} parameter should not be used.
The association will not be changed if one of these function are called 
with a given data frame on a preference object having an associated data frame.
}
\section{Partial Evaluation Before String Output}{


The functions \code{show.pref} and \code{pref.str} have the optional parameter \code{df}.
If this parameter is given, these functions call \code{partial.eval.pref} before they output or return the preference string.
The following equalities hold:

\itemize{
  \item \code{as.character(partial.eval.pref(p, df)) == pref.str(p, df)}
  \item \code{show(partial.eval.pref(p, df))} produces the same console output as \code{show.pref(p, df)}
}
}

\examples{

f <- function(x) 2*x
p <- true(cyl == f(1))

# prints 'true(cyl == f(1))'
p

# prints 'true(cyl == 2)'
show.pref(p, mtcars)
partial.eval.pref(p, mtcars)

}
\seealso{
See \code{\link{general_pref}} for more utility functions for preferences.
}
