% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trading_mdh}
\alias{trading_mdh}
\title{Historical Market Data}
\usage{
trading_mdh(
  connection,
  market_id = "ROFX",
  symbol,
  date,
  date_from,
  date_to,
  tidy = TRUE
)
}
\arguments{
\item{connection}{S4. \strong{Mandatory} Formal rRofexConnection class object}

\item{market_id}{String. Market to which we are going to connect.
\itemize{
\item \strong{ROFX} - Matba Rofex.
\item \strong{MERV} - S&P Merval.
}}

\item{symbol}{String. Use \code{\link{trading_instruments}} to see which symbols are available.}

\item{date}{String. Date to be queried. With format '\%Y-\%m-\%d'.}

\item{date_from}{String. Used together with 'date_to'.}

\item{date_to}{String. Userd together with 'date_from'.}

\item{tidy}{Logical. Data arranged on a tidy format.}
}
\value{
If correct, it will load a data frame.
}
\description{
Access Historical Trades for a given instrument.
}
\seealso{
Other market data functions: 
\code{\link{trading_currencies}()},
\code{\link{trading_md}()}
}
\concept{market data functions}
